* fplot.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Plot a function y = f(x)";
title2 "Linear function";
data fplot;
	* Minimum and maximum values of x;
	xmin = -5;
	* Use for ln function, must have x > 0;
	*xmin = 0.001; 
	xmax = 5;
	* Divisions between xmin and xmax (more = smoother graph);
	xdiv = 100;
	* Calculate step length;
	xlength = (xmax-xmin)/xdiv;
	* Find x and y = f(x) values for the plot;
	do i=0 to xdiv;
		x = xmin + i*xlength;
		* Insert f(x) formula here;
		* line function;
		y = 2*x + 1; 
		* quadratic function;
		*y = -x**2 + 2*x + 5; 
		* exponential function;
		*y = exp(x);
		* ln function;
		*y = log(x);
		* absolute value function;
		*y = abs(x);
		* normal distribution;
		*mu = 1; 
		*sig2 = 1; 
		*y = (1/sqrt(2*3.14159*sig2))*exp(-((x-mu)**2)/(2*sig2));
		* Output x and y to SAS data file;
		output;
	end;
run;
* Print data;
proc print data=fplot;
run;
* Plot y = f(x);
proc gplot data=fplot;
	plot y*x=1 / href=0 vref=0 whref=3 wvref=3 vaxis=axis1 haxis=axis1;
	symbol1 i=join v=none c=red width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
